
![[Pasted image 20250608184816.png]]


![[Pasted image 20250608185035.png]]

![[Pasted image 20250608185056.png]]


### **Overview of RADIUS CoA**

- **Purpose**: Provides a mechanism to dynamically modify the attributes of a AAA session after authentication.
- **How It Works**:
    - When a policy change occurs (e.g., user posture or group policy), the AAA server (e.g., Cisco ISE) sends an unsolicited RADIUS CoA request to reinitialize authentication and apply the new policy.
    - CoA operates in a **pushed model** as defined in **RFC 5176**, where requests originate from the AAA server and are sent to the Network Access Device (NAD).

---

### **Types of RADIUS CoA Messages**

#### **From AAA Server to NAD**

1. **Disconnect-Request**:
    - Terminates one or more user sessions and discards all associated session context.
2. **CoA-Request**:
    - Dynamically modifies an authorization session. Actions may include:
        - Reauthentication
        - Port bounce
        - Port disable

#### **From Network Access Device (NAD) to AAA Server (Responses)**

1. **Disconnect-ACK**:
    - Confirms that one or more user sessions have been disconnected.
2. **Disconnect-NAK**:
    - Indicates the NAD was unable to disconnect one or more user sessions.
3. **CoA-ACK**:
    - Confirms that one or more user sessions have been modified based on the CoA request.
4. **CoA-NAK**:
    - Indicates the NAD was unable to apply the requested CoA.

---

### **Attributes Required for CoA**

- **NAS Identification Attributes**:
    - **NAS-IP-Address**: IPv4 address of the NAD.
    - **NAS-Identifier**: String identifying the NAD.

- **Session Identification Attributes**:
    
    - **User-Name**: Name of the user associated with the session.
    - **NAS-Port**: Port on which the session is terminated.
    - **Called-Station-Id**: MAC address of the authenticator.
    - **Calling-Station-Id**: MAC address of the supplicant (client).
    - **Acct-Session-Id**: Unique identifier for a session on the NAD.

---

### **Use Cases for RADIUS CoA**

RADIUS CoA is essential for various Cisco ISE services and dynamic network changes:

1. **Central Web Authentication**:
    
    - CoA updates the user's authorization session after authenticating via a guest captive portal.
2. **Client Posturing**:
    
    - CoA changes the session policy based on the posture assessment status (e.g., compliant or non-compliant).
3. **Client Profiling**:
    
    - CoA updates the session policy after profiling and classifying the device.
4. **Rapid Threat Containment**:
    
    - CoA modifies user authorization when a malicious event is detected (e.g., by Cisco Secure Firewall or Cisco Secure Network Analytics).
5. **Manual Administrator Control**:
    
    - Administrators can manually trigger reauthentication, block a host, or push updated policies for troubleshooting purposes.

---

### **Example: RADIUS CoA Flow for Client Posturing**

1. **Initial Connection and Authentication**:
    
    - Endpoint connects and starts EAP authentication.
    - Authenticator encapsulates EAP exchange in RADIUS packets and sends them to the Cisco ISE server.
2. **Temporary Policy Assignment**:
    
    - Cisco ISE performs initial authentication but has not yet assessed the endpoint's posture.
    - A **temporary policy** is assigned via an **Access-Accept** message containing a **downloadable access control list (DACL)**.
    - The DACL allows limited access (e.g., to Cisco ISE and remediation servers).
3. **Posture Assessment**:
    
    - Endpoint completes posture assessment and is found compliant.
    - Cisco ISE associates a full-access policy with the session.
4. **Reauthentication with CoA**:
    
    - Cisco ISE sends a **CoA-Request** to the switch, requesting reauthentication of the session.
    - The switch acknowledges with a **CoA-ACK** packet.
5. **Session Update**:
    
    - The switch sends a new RADIUS **Access-Request** with the session ID and authentication data.
    - Cisco ISE responds with an **Access-Accept** message, this time without the DACL, granting full access to the endpoint.

---

### **Key Takeaways**

- **Dynamic Session Management**: CoA enables real-time changes to a user's session without requiring manual disconnection or reauthentication.
- **Critical for Cisco ISE Services**: CoA is central to features like client posturing, profiling, and rapid threat containment.
- **Supported CoA Actions**: Reauthentication, port bouncing, disabling ports, and session termination.
- **Attributes Are Key**: Proper identification of NADs and sessions (e.g., using NAS-IP-Address, User-Name, or Acct-Session-Id) is necessary for successful CoA operations.